/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.AbstractListModel;
import com.sun.java.swing.Action;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JToggleButton;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.FileChooserUI;
import com.sun.java.swing.plaf.basic.BasicDirectoryPaneUI;
import com.sun.java.swing.plaf.basic.BasicListCellRenderer;
import com.sun.java.swing.preview.DirectoryModel;
import com.sun.java.swing.preview.FileType;
import com.sun.java.swing.preview.JDirectoryPane;
import com.sun.java.swing.preview.JFileChooser;
import com.sun.java.swing.preview.TypedFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;

public class BasicFileChooserUI
extends FileChooserUI {
    protected BasicDirectoryPaneUI directoryPaneUI;
    protected JPanel centerPanel;
    protected JFileChooser fileChooser;
    protected JDirectoryPane directoryPane;
    protected Component accessory;
    protected Listener listener;
    protected Action goHomeAction = new GoHomeAction();
    protected Action mkdirAction = new MkdirAction();
    protected Action cancelAction = new CancelAction();
    protected Action okayAction = new OkayAction();
    protected TypesComboBoxModel typesComboBoxModel;
    private static Dimension PREF_SIZE = new Dimension(500, 300);
    private static Dimension MIN_SIZE = new Dimension(300, 200);
    private JComboBox currentDir;
    private JButton okayButton;
    private JButton cancelButton;
    private JTextField filename;
    private JComboBox types;
    private JPanel bodyPanel;
    private Icon newFolderIcon;
    private Icon upFolderIcon;
    private Icon homeFolderIcon;
    private Icon listViewIcon;
    private Icon detailsViewIcon;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension hstrut25 = new Dimension(25, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicFileChooserUI((JFileChooser)jComponent);
    }

    public BasicFileChooserUI(JFileChooser jFileChooser) {
        if (this.newFolderIcon == null) {
            this.newFolderIcon = UIManager.getIcon("FileChooser.newFolder");
            this.upFolderIcon = UIManager.getIcon("FileChooser.upFolder");
            this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolder");
            this.detailsViewIcon = UIManager.getIcon("FileChooser.detailsView");
            this.listViewIcon = UIManager.getIcon("FileChooser.listView");
        }
    }

    public void installUI(JComponent jComponent) {
        this.fileChooser = (JFileChooser)jComponent;
        this.directoryPane = this.fileChooser.getDirectoryPane();
        this.accessory = this.fileChooser.getAccessory();
        this.fileChooser.setLayout(new BoxLayout(this.fileChooser, 1));
        this.fileChooser.add(Box.createRigidArea(vstrut10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.fileChooser.add(jPanel);
        this.fileChooser.add(Box.createRigidArea(vstrut10));
        JLabel jLabel = new JLabel("Look in:");
        jLabel.setAlignmentX(0.0f);
        jLabel.setAlignmentY(0.5f);
        jPanel.add(Box.createRigidArea(hstrut10));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(hstrut25));
        this.currentDir = new JComboBox();
        this.currentDir.setAlignmentX(0.0f);
        this.currentDir.setAlignmentY(0.5f);
        jPanel.add(this.currentDir);
        jPanel.add(Box.createRigidArea(hstrut10));
        NoFocusButton noFocusButton = new NoFocusButton(this.upFolderIcon);
        noFocusButton.setToolTipText("Up One Level");
        noFocusButton.setAlignmentX(0.0f);
        noFocusButton.setAlignmentY(0.5f);
        noFocusButton.setMargin(shrinkwrap);
        noFocusButton.setFocusPainted(false);
        noFocusButton.addActionListener(this.directoryPane.getGoUpAction());
        jPanel.add(noFocusButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        noFocusButton = new NoFocusButton(this.homeFolderIcon);
        noFocusButton.setToolTipText("Home");
        noFocusButton.setAlignmentX(0.0f);
        noFocusButton.setAlignmentY(0.5f);
        noFocusButton.setMargin(shrinkwrap);
        noFocusButton.setFocusPainted(false);
        noFocusButton.addActionListener(this.goHomeAction);
        jPanel.add(noFocusButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        noFocusButton = new NoFocusButton(this.newFolderIcon);
        noFocusButton.setToolTipText("Create New Folder");
        noFocusButton.setAlignmentX(0.0f);
        noFocusButton.setAlignmentY(0.5f);
        noFocusButton.setMargin(shrinkwrap);
        noFocusButton.setFocusPainted(false);
        noFocusButton.addActionListener(this.mkdirAction);
        jPanel.add(noFocusButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        JToggleButton jToggleButton = new JToggleButton(this.listViewIcon);
        jToggleButton.setToolTipText("List");
        jToggleButton.setEnabled(false);
        jToggleButton.setFocusPainted(false);
        jToggleButton.setAlignmentX(0.0f);
        jToggleButton.setAlignmentY(0.5f);
        jToggleButton.setMargin(shrinkwrap);
        jPanel.add(jToggleButton);
        jToggleButton = new JToggleButton(this.detailsViewIcon);
        jToggleButton.setToolTipText("Details");
        jToggleButton.setFocusPainted(false);
        jToggleButton.setSelected(true);
        jToggleButton.setEnabled(false);
        jToggleButton.setAlignmentX(0.0f);
        jToggleButton.setAlignmentY(0.5f);
        jToggleButton.setMargin(shrinkwrap);
        jPanel.add(jToggleButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.add((Component)this.directoryPane, "Center");
        if (this.accessory != null) {
            this.centerPanel.add(this.accessory, "East");
        }
        this.fileChooser.add(this.centerPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createRigidArea(hstrut10));
        this.fileChooser.add(Box.createRigidArea(vstrut10));
        this.fileChooser.add(jPanel2);
        this.fileChooser.add(Box.createRigidArea(vstrut10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jLabel = new JLabel("File name:");
        jPanel3.add(jLabel);
        jPanel3.add(Box.createRigidArea(vstrut10));
        jLabel = new JLabel("Files of type:");
        jPanel3.add(jLabel);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(hstrut25));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.filename = new JTextField();
        this.filename.addActionListener(this.okayAction);
        jPanel4.add(this.filename);
        jPanel4.add(Box.createRigidArea(vstrut10));
        this.typesComboBoxModel = this.createTypesComboBoxModel();
        this.types = new JComboBox(this.typesComboBoxModel);
        this.types.setRenderer(this.createTypeRenderer());
        jPanel4.add(this.types);
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createRigidArea(hstrut10));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        this.okayButton = new 1("Open");
        this.okayButton.addActionListener(this.okayAction);
        this.okayButton.setToolTipText("Open");
        jPanel5.add(this.okayButton);
        jPanel5.add(Box.createRigidArea(vstrut10));
        this.cancelButton = new 2("Cancel");
        this.cancelButton.setToolTipText("Cancel");
        this.cancelButton.addActionListener(this.cancelAction);
        jPanel5.add(this.cancelButton);
        jPanel2.add(jPanel5);
        jPanel2.add(Box.createRigidArea(hstrut10));
        this.listener = this.createListener();
        this.directoryPane.addPropertyChangeListener(this.listener);
        this.directoryPane.getListSelectionModel().addListSelectionListener(this.listener);
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.fileChooser) {
            throw new IllegalComponentStateException(String.valueOf(this) + " was asked to deinstall() " + jComponent + " when it only knows about " + this.fileChooser + ".");
        }
        this.directoryPane.getModel().removePropertyChangeListener(this.listener);
        this.directoryPane.getListSelectionModel().removeListSelectionListener(this.listener);
        this.listener = null;
        this.centerPanel = null;
        this.directoryPane = null;
        this.fileChooser = null;
        this.accessory = null;
        this.fileChooser.removeAll();
        this.fileChooser = null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return PREF_SIZE;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void update() {
        DirectoryModel directoryModel = this.directoryPane.getModel();
        File file = directoryModel.getCurrentDirectory();
        this.currentDir.removeAllItems();
        this.currentDir.addItem(file.getName());
        this.mkdirAction.setEnabled(file.canWrite());
        this.typesComboBoxModel.setTypes(this.fileChooser.getChoosableFileTypes());
    }

    protected TypeRenderer createTypeRenderer() {
        return new TypeRenderer();
    }

    protected TypesComboBoxModel createTypesComboBoxModel() {
        return new TypesComboBoxModel();
    }

    protected Listener createListener() {
        return new Listener();
    }

    protected File mkdir(String string) {
        String string2 = this.directoryPane.getModel().getCurrentDirectory().getPath();
        File file = new File(string2, string);
        int n = 1;
        while ((file.exists() || !file.mkdirs()) && n < 100) {
            file = new File(string2, String.valueOf(string) + " " + n);
            ++n;
        }
        return file;
    }

    private final class 1
    extends JButton {
        public Dimension getMaximumSize() {
            return new Dimension(75, super.getMaximumSize().height);
        }

        /* synthetic */ 1(String string) {
            super(string);
        }
    }

    private final class 2
    extends JButton {
        public Dimension getMaximumSize() {
            return new Dimension(75, super.getMaximumSize().height);
        }

        /* synthetic */ 2(String string) {
            super(string);
        }
    }

    protected class NoFocusButton
    extends JButton {
        public NoFocusButton(Icon icon) {
            super(icon);
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    public class TypeRenderer
    extends BasicListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object == BasicFileChooserUI.this.typesComboBoxModel) {
                this.setText("All Types (*.*)");
            } else {
                this.setText(((FileType)object).getPresentationName());
            }
            return this;
        }

        public TypeRenderer() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }
    }

    protected class TypesComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        boolean itIsI_PleaseDoNotPanic = false;
        Object value = this;
        Vector types;

        protected TypesComboBoxModel() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }

        protected void setTypes(Vector vector) {
            Vector vector2 = this.types;
            this.types = null;
            if (vector2 != null && !this.itIsI_PleaseDoNotPanic) {
                this.fireIntervalRemoved(this, 0, vector2.size() - 1);
            }
            this.types = vector;
            if (vector != null && vector.size() > 0 && !this.itIsI_PleaseDoNotPanic) {
                this.fireIntervalAdded(this, 0, vector.size() - 1);
            }
        }

        public void setSelectedItem(Object object) {
            this.itIsI_PleaseDoNotPanic = true;
            if (object == this) {
                BasicFileChooserUI.this.directoryPane.getModel().setShownType(null);
            } else {
                BasicFileChooserUI.this.directoryPane.getModel().setShownType((FileType)object);
            }
            this.itIsI_PleaseDoNotPanic = false;
        }

        public Object getSelectedItem() {
            FileType fileType = BasicFileChooserUI.this.directoryPane.getModel().getShownType();
            if (fileType == null) {
                return this;
            }
            return fileType;
        }

        public int getSize() {
            Vector vector = this.types;
            if (vector == null) {
                return 1;
            }
            return vector.size() + 1;
        }

        public Object getElementAt(int n) {
            Vector vector = this.types;
            if (vector == null) {
                return this;
            }
            int n2 = vector.size();
            if (n >= n2) {
                return this;
            }
            return vector.elementAt(n);
        }
    }

    protected class Listener
    implements PropertyChangeListener,
    ListSelectionListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("accessory") && BasicFileChooserUI.this.centerPanel != null) {
                BasicFileChooserUI.this.centerPanel.add((Component)propertyChangeEvent.getNewValue(), "Center");
            }
            BasicFileChooserUI.this.update();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TypedFile typedFile = BasicFileChooserUI.this.directoryPane.getSelectedFile();
            if (!listSelectionEvent.getValueIsAdjusting() && typedFile != null && !typedFile.getType().isContainer()) {
                BasicFileChooserUI.this.filename.setText(typedFile.getName());
            }
        }

        Listener() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.directoryPane.getModel().setCurrentDirectory(null);
        }
    }

    protected class MkdirAction
    extends AbstractAction {
        protected MkdirAction() {
            super("New Folder");
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(BasicFileChooserUI.this.fileChooser, "Create a new folder named:");
            if (string != null) {
                File file = BasicFileChooserUI.this.mkdir(string);
                if (file.exists()) {
                    BasicFileChooserUI.this.directoryPane.getModel().setCurrentDirectory(file);
                    return;
                }
                JOptionPane.showMessageDialog(BasicFileChooserUI.this.fileChooser, "Could not create folder: \n" + string, "New Folder Failed", 0);
            }
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.fileChooser.performCancel();
        }

        CancelAction() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }
    }

    protected class OkayAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.fileChooser.performOkay();
        }

        OkayAction() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }
    }
}

